#pragma once

#ifdef RLVISION_EXPORTS
#define RLVISION_API __declspec(dllexport)
#else
#define RLVISION_API __declspec(dllimport)
#endif

//-------------------------------------
enum RLVISION_API RLUI_THEME
{
	RLUI_THEME_DEFAULT = 0,	// Windows native theme
	RLUI_THEME_OFFICE_2000,
	RLUI_THEME_OFFICE_XP,
	RLUI_THEME_OFFICE_2003,
	RLUI_THEME_VS_2005,
	RLUI_THEME_OFFICE_2007_BLUE,
	RLUI_THEME_OFFICE_2007_BLACK,
	RLUI_THEME_OFFICE_2007_SILVER,
	RLUI_THEME_OFFICE_2007_AQUA,
	RLUI_THEME_CARBON,
	RLUI_THEME_VS_2008,
	RLUI_THEME_VS_2010,
	RLUI_THEME_SCENIC,
	RLUI_THEME_OFFICE_2010_BLUE,
	RLUI_THEME_OFFICE_2010_BLACK,
	RLUI_THEME_OFFICE_2010_SILVER,
	RLUI_THEME_VS_2012_LIGHT,
	RLUI_THEME_VS_2012_DARK,
	RLUI_THEME_VS_2012_BLUE,
	RLUI_THEME_OFFICE_2013_WHITE,
	RLUI_THEME_OFFICE_2013_GRAY,
	RLUI_THEME_OFFICE_2013_DARK_GRAY,
	RLUI_THEME_VS_2013_LIGHT,
	RLUI_THEME_VS_2013_DARK,
	RLUI_THEME_VS_2013_BLUE,
	RLUI_THEME_OFFICE_2016_COLORFUL,
	RLUI_THEME_OFFICE_2016_DARK_GRAY,
	RLUI_THEME_OFFICE_2016_WHITE,
	RLUI_THEME_OFFICE_2016_BLACK,
	RLUI_THEME_VS_2019_LIGHT,
	RLUI_THEME_VS_2019_DARK,
	RLUI_THEME_VS_2019_BLUE,
	RLUI_THEME_OFFICE_2019_COLORFUL,
	RLUI_THEME_OFFICE_2019_DARK_GRAY,
	RLUI_THEME_OFFICE_2019_WHITE,
	RLUI_THEME_OFFICE_2019_BLACK,
	RLUI_THEME_CUSTOM = 9999,
};

//------------------Ҵ-------------------
#define RV_OK		 0		//ҳɹ
#define RV_FAIL		 -1		//ûҵ
#define RV_DOGERROR  -2		//ܹ

//----------------------------------------
//:IRLMoveInterface
//:˶ӿ
//----------------------------------------
class IRLMoveInterface
{
public:
	virtual bool MoveTo(double x,double y) = 0;
	virtual double GetPosX() = 0;
	virtual double GetPosY() = 0;
};

//----------------------------------------
//:IRLInstance
//:λ
//----------------------------------------
struct RLVISION_API IRLInstance
{
	double x;  //X mm
	double y;  //Y mm
	int nCore;  //0-100
	double fAngle;  //Ƕ
	int nModelIndex;  //ģ
	char strModelName[255];  //ģ
};

//----------------------------------------
//:IRLVisionLocator
//:λ
//----------------------------------------
class RLVISION_API IRLVisionLocator
{
public:
	explicit IRLVisionLocator(IRLMoveInterface* pMoveInterFace,bool bEnglishUI,RLUI_THEME nUITheme);
	~IRLVisionLocator(void);

public:
	unsigned long  GetVersion();

public:
	bool  Connect();  //
	bool  Disconnct();  //Ͽ

public:
	void  ReadFile(char*  strFile);  //ļ
 	void  WriteFile(char*  strFile);  //дļ

public:
	void  ShowModelUI();  //ʾģ
	void  ShowCalibrateUI();  //ʾ
	void*  GetDisplayUIHandle();  //ʾҳHandle

public:
	int  FindInstance();  //
	int  GetInstanceCount(); //ȡ
	IRLInstance  GetInstanceAt(int nIndex);  //ȡҽ

private:
	void* m_pImpl;
};

